#if 1
#include <cstdio>
#include <cstring>
#include <cassert>
#include <iostream>
#include <string>
#include <vector>
#include <set>
#include <map>
#include <stack>
#include <queue>
#include <algorithm>
using namespace std;

#define pb push_back
#define mp make_pair
#define X first
#define Y second

typedef long long li;
typedef long double ld;
typedef pair<li,li> pii;
typedef vector<li> vi;
typedef vector<vi> vvi;

struct edge
{
	edge() {}
	edge(li a, li b, li t, li id) : a(a), b(b), t(t), id(id) {}
	li a, b, t, id;
};

struct edges
{
	edges() {}
	edges(li cnt, li id, li w) : cnt(cnt), id(id), w(w) {}
	li cnt, id, w;
};

li n, m;
vvi g, w, id;
const li inf = 1e10 + 7;
void dijkstra(li s, vi &dist)
{
	dist.assign(n, inf);
	dist[s] = 0;
	set<pii> q;
	q.insert(mp(0, s));
	while(q.size())
	{
		pii now = *q.begin();
		q.erase(q.begin());
		if(now.first != dist[now.second]) continue;
		for (li i = 0; i < g[now.second].size(); ++i)
		{
			li to = g[now.second][i];
			if(now.first + w[now.second][i] < dist[to])
			{
				dist[to] = now.first + w[now.second][i];
				q.insert(mp(dist[to], to));
			}
		}
	}
}

vector<li> tin, fup;
vector<li> ans;
map<pii, edges> WD;
void dfs(li v, vvi &g, vvi &id, li p, li time)
{
	tin[v] = time++;
	fup[v] = tin[v];
	for (li i = 0; i < g[v].size(); ++i)
	{
		li to = g[v][i];
		if(to == p) continue;
		if(!tin[to])
		{
			dfs(to, g, id, v, time);
			fup[v] = min(fup[v], fup[to]);
		}
		else fup[v] = min(fup[v], fup[to]);

		if((fup[v] < fup[to]) && (WD[mp( min(v,to), max(v,to) )].cnt == 1)) 
			ans.push_back(id[v][i]);
	}
}



int main()
{
#ifdef _DEBUG
	freopen("input.txt", "r", stdin);
#endif
	cin >> n >> m;
	
	for (li i = 0; i < m; ++i)
	{
		li a, b, t;
		cin >> a >> b >> t;
		--a; --b;
		pii e = mp( min(a, b), max(a, b) );
		if((WD.find(e) == WD.end()) || (WD[e].w > t)) WD[e] = edges(1, i + 1, t);
		else if(WD[e].w == t) WD[e].cnt++;
	}

	vector<edge> E;
	for (map<pii, edges>::iterator it = WD.begin(); it != WD.end(); ++it)
		E.push_back( edge(it->first.first, it->first.second, it->second.w, it->second.id));

	w.resize(n); g.resize(n); id.resize(n);
	for (li i = 0; i < E.size(); ++i)
	{
		li a, b, t, iD;
		a = E[i].a;
		b = E[i].b;
		t = E[i].t;
		iD = E[i].id;
		g[a].push_back(b);
		w[a].push_back(t);
		g[b].push_back(a);
		w[b].push_back(t);
		id[a].push_back(iD);
		id[b].push_back(iD);
	}
	vi dist1, dist2;
	dijkstra(0, dist1);
	dijkstra(n-1, dist2);
 	vvi newg(n), newid(n);
	for (li i = 0; i < g.size(); ++i)
	{
		for (li j = 0; j < g[i].size(); ++j)
		{
			li to = g[i][j];
			li d1 = dist1[i] + w[i][j] + dist2[to];
			li d2 = dist2[i] + w[i][j] + dist1[to];
			if(min(d1, d2) == dist2[0])
			{
				newg[i].push_back(to);
				newid[i].push_back(id[i][j]);
			}
		}
	}
	tin.assign(n, 0);
	fup.assign(n, 0);
	dfs(0, newg, newid, -1, 1);
	cout << ans.size() << endl;
	sort(ans.begin(), ans.end());
	for (li i = 0; i < ans.size(); ++i) cout << ans[i] << ' ';
	return 0;
}
#endif